/*
 * 作成日: 2008/08/05
 * 著作権: Copyright (c) 2005 ZIGEN
 * ライセンス：Eclipse Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.dto.rule;

import java.sql.Types;

import zigen.plugin.db.core.TableColumn;

public class SymfowareDtoMappingFactory extends DefaultDtoMappingFactory {

    public String getJavaType(TableColumn column) {
        return getJavaType(column.getDataType());
    }

    public String getJavaType(int type) {
        switch (type) {

        case Types.INTEGER:
            return "Integer"; //$NON-NLS-1$

        case Types.BIGINT:
        case Types.REAL:
        case Types.FLOAT:
        case Types.DOUBLE:
            return "java.math.BigDecimal"; //$NON-NLS-1$

        case Types.DATE:
            return "java.sql.Date"; //$NON-NLS-1$

        case Types.TIME:
            return "java.sql.Time"; //$NON-NLS-1$

        case Types.TIMESTAMP:
            return "java.sql.Timestamp"; //$NON-NLS-1$

        default:
            return super.getJavaType(type);
        }
    }
}